/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (09/05/07)
 */    
package com.ejie.p06b.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import com.ejie.p06b.general.P06BConstantes;

/**
 * Esta clase representa un conjunto de mtodos para el manejo de fechas y horas.
 */
public class P06BFecha {
    public final static String SEPARADOR = "/";

	public final static String FECHA_ES         = "dd/MM/yyyy";
	public final static String FECHA_EU       = "yyyy/MM/dd";
	public final static String HORA_COMPLETA = "HH:mm:ss";
	public final static String HORA_PARCIAL = "HH:mm";
	
	/**
   	 *  Obtiene un String correspondiente a una nueva hora con el formato HH:mm:ss
     *  @param   date    hora que queremos formatear
   	 *  @return  String  hora con el formato HH:mm:ss
   	 */
	public static String getHoraCompleta(Date date) {
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(HORA_COMPLETA);
   		return simpleDateFormat.format(date);
   	}
	
   	/**
   	 *  Obtiene un String correspondiente a una nueva fecha con el formato dd-MM-yyyy
   	 *  @param   date    fecha que queremos formatear.   
     *  @return  String  fecha con el formato dd-MM-yyyy
   	 */
	public static String getFecha(Date date) 
	{
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FECHA_ES);
   		return simpleDateFormat.format(date);
   	}

	public static String getFechaFormateada(Date date,Locale lLocale){
		SimpleDateFormat simpleDateFormat = null;
		
		if (lLocale.getLanguage().equals(P06BConstantes.P06B_IDIOMA_ES)){
			simpleDateFormat = new SimpleDateFormat(FECHA_ES);
		}
		else{
			simpleDateFormat = new SimpleDateFormat(FECHA_EU);
		}
		return simpleDateFormat.format(date);
	}
	
	public static String getFechaFormateadaFromIdioma(Date date,String idioma){
		if (date==null)
			return "";
		
		SimpleDateFormat simpleDateFormat = null;
		
		if (idioma.equals(P06BConstantes.P06B_IDIOMA_ES)){
			simpleDateFormat = new SimpleDateFormat(FECHA_ES);
		}
		else{
			simpleDateFormat = new SimpleDateFormat(FECHA_EU);
		}
		return simpleDateFormat.format(date);
	}
	
	public static String getFechaHoraFormateadaFromIdioma(Date date,String idioma){
		if (date==null)
			return "";
		
		SimpleDateFormat simpleDateFormat = null;
		
		if (idioma.equals(P06BConstantes.P06B_IDIOMA_ES)){
			simpleDateFormat = new SimpleDateFormat(FECHA_ES + " " + HORA_COMPLETA);
		}
		else{
			simpleDateFormat = new SimpleDateFormat(FECHA_EU + " " + HORA_COMPLETA);
		}
		return simpleDateFormat.format(date);
	}
	
	public static boolean isFechaValida(String fecha, String idioma){
		//SimpleDateFormat simpleDateFormat = null;
	    DateFormat simpleDateFormat = null;
	    try{
			if (idioma.equals(P06BConstantes.P06B_IDIOMA_ES)){
				simpleDateFormat = new SimpleDateFormat(FECHA_ES);
			}
			else{
				simpleDateFormat = new SimpleDateFormat(FECHA_EU);
			}
			simpleDateFormat.setLenient(false);
			Date dt2 = simpleDateFormat.parse(fecha);
			
			//Se aade el format a la validacion para que no acepte p.e. 01/01/200G
			//y para que obligue a introducir todos los digitos, no permitiendo 01/01/07
			String fechaFormateada = simpleDateFormat.format(dt2);
		    if(!fechaFormateada.equals(fecha)) { 
		    	return false;
		    } 
		}catch (ParseException e) {
			return false;
	    }
	    catch (IllegalArgumentException e) {
	    	return false;
	    }
		return true;
	}
	
	public static boolean isHoraValida(String fecha){
		SimpleDateFormat simpleDateFormat = null;
		try{
			simpleDateFormat = new SimpleDateFormat(HORA_PARCIAL);
            simpleDateFormat.setLenient(false);
			Date dt2 = simpleDateFormat.parse(fecha);
		}catch (ParseException e) {
			return false;
	    }
	    catch (IllegalArgumentException e) {
	    	return false;
	    }   
		return true;
	}
	
	public static String fechaFromFechaEu(String fecha){
		String result = "";
		try{
			String ano = fecha.substring(0,fecha.indexOf("/"));
			fecha = fecha.substring(fecha.indexOf("/")+1,fecha.length());
			String mes = fecha.substring(0,fecha.indexOf("/"));
			fecha = fecha.substring(fecha.indexOf("/")+1,fecha.length());
			String dia = fecha;
			result=dia+"/"+mes+"/"+ano;
		}catch (Exception e) {
	    	return "";
	    }   
		return result;
	}
	
	public static String fechaEuFromFecha(String fecha){
		String result = "";
		if(fecha==null
				|| fecha.equals(""))
			return fecha;
		try{
			String dia = fecha.substring(0,fecha.indexOf("/"));
			fecha = fecha.substring(fecha.indexOf("/")+1,fecha.length());
			String mes = fecha.substring(0,fecha.indexOf("/"));
			fecha = fecha.substring(fecha.indexOf("/")+1,fecha.length());
			String ano = fecha;
			result=ano+"/"+mes+"/"+dia;
		}catch (Exception e) {
	    	return "";
	    }   
		return result;
	}
	
	public static boolean isFechaBefore(String fechaDesde, String fechaHasta, String idioma) throws ParseException{
		SimpleDateFormat simpleDateFormat = null;
		if (idioma.equals(P06BConstantes.P06B_IDIOMA_ES)){
			simpleDateFormat = new SimpleDateFormat(FECHA_ES);
		}
		else{
			simpleDateFormat = new SimpleDateFormat(FECHA_EU);
		}
		Calendar c1= Calendar.getInstance();
		c1.setTime(simpleDateFormat.parse(fechaDesde));
		Calendar c2= Calendar.getInstance();
		c2.setTime(simpleDateFormat.parse(fechaHasta));
		if(c1.before(c2))
			return true;
		else if(c1.equals(c2))
			return true;
		else
			return false;
	}

	public static Date dateDesdeString(String fecha, String idioma){
		Date date = null;
		SimpleDateFormat simpleDateFormat = null;
		if (idioma.equals(P06BConstantes.P06B_IDIOMA_ES)){
			simpleDateFormat = new SimpleDateFormat(FECHA_ES);
		}
		else{
			simpleDateFormat = new SimpleDateFormat(FECHA_EU);
		}
		try{
			date = simpleDateFormat.parse(fecha);
		}
		catch(ParseException pe){
			date = null;
		}
		return date;
	}

}	